using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ConsoleApp154
{
    internal class Program
    {
        class VanOgranicenja : ArgumentException
        {
            public VanOgranicenja(string poruka) : base(poruka) { }
        }
        static void Main(string[] args)
        {
            try
            {
                int n = int.Parse(Console.ReadLine());
                if ((n < 2) || (n > 500000))
                {
                    throw new VanOgranicenja("Unos je van ogranicenja (2 <= n >= 500000).");
                }
                string s = Console.ReadLine();
                char[] delovi = new char[n];
                int i = 0; int br1 = 0; int br2 = 0;
                foreach (char c in s)
                {
                    delovi[i] = c;
                    if (delovi[i] == '+')
                    {
                        br1 = i + 1; br2 = i - 1;
                    }
                    i++;
                }
                

                int put1 = 0; int put2 = 0; int put = 0;

                if (br1 == n)
                {
                    br1 = 0;
                }
                while (true)
                {
                    if (delovi[br1] == '.')
                    {
                        put++;
                    }
                    else if (delovi[br1] == '#')
                    {
                        put++;
                        put1 = put;
                        put = 0;
                        break;
                    }
                    if (br1 == n - 1)
                    {
                        br1 = 0;
                    }
                    else
                    {
                        br1++;
                    }
                }

                if (br2 < 0)
                {
                    br2 = n - 1;
                }
                while (true)
                {
                    if (delovi[br2] == '.')
                    {
                        put++;
                    }
                    else if (delovi[br2] == '#')
                    {
                        put++;
                        put2 = put;
                        put = 0;
                        break;
                    }
                    if (br2 == 0)
                    {
                        br2 = n - 1;
                    }
                    else
                    {
                        br2--;
                    }
                }
                Console.WriteLine(Math.Min(put1, put2));
                
            }
            catch (ArgumentException ae)
            {
                Console.WriteLine("Detalji greške: " + ae.Message);
            }
            catch (Exception e)
            {
                Console.WriteLine("Desila se neocekivana greška.");
                Console.WriteLine("Detalji greške: " + e.Message);
            }
        }
    }
}